package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeCouponDto;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeSettlementBatchDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeSettlementBatchSearchParam;
import java.util.List;
import java.util.Map;

/**
 * 建行生活对账批次
 * @author kjj mybatis generator 
 * @date 2024-11-12
 */
@AdvancedFeignClient
public interface RemoteCcbLifeSettlementBatchService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 建行生活对账批次集合
     */
    List<CcbLifeSettlementBatchDto> selectPage(CcbLifeSettlementBatchSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbLifeSettlementBatchSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 建行生活对账批次
     */
    CcbLifeSettlementBatchDto selectById(Long id);

    /**
     * 新增
     * @param dto 建行生活对账批次
     * @return 执行结果
     */
    int insert(CcbLifeSettlementBatchDto dto);

    /**
     * 更新
     * @param dto 建行生活对账批次
     * @return 影响行数
     */
    int update(CcbLifeSettlementBatchDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量插入数据到优惠券表中
     * @param dtos
     */
    int batchInsert(List<CcbLifeSettlementBatchDto> dtos);

    /**
     * 批量修改
     * @param dtos
     * @return
     */
    Integer batchUpdate(List<CcbLifeSettlementBatchDto> dtos);

    /**
     * 根据对账账户和对账期次查询
     * @param monthList
     * @param accountNoList
     * @return
     */
    List<CcbLifeSettlementBatchDto> selectByAccountNoAndMonth(List<String> monthList, List<String> accountNoList);

    /**
     * 根据商户号和对账期次查询
     * @param monthList
     * @param merchantNoList
     * @return
     */
    List<CcbLifeSettlementBatchDto> selectByMerchantNoAndMonth(List<String> monthList, List<String> merchantNoList);
}