package cn.com.duiba.quanyi.center.api.param.ccbLife;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.function.LongFunction;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Nullable;

/**
 * 建行生活对账批次
 * @author mybatis generator 
 * @date 2024-11-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CcbLifeSettlementBatchSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17313790901772890L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 对账期次
     */
    private Long month;

    /**
     * 商户编号
     */
    private String merchantNo;

    /**
     * 商户名称
     */
    private String merchantName;

    /**
     * 收款账户
     */
    private String accountNo;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 开户行
     */
    private String accountBank;

    /**
     * 报销金额
     */
    private Long totalAmount;

    /**
     * 结算状态 0初始化  1数据处理中  2数据处理完成（未结算） 3已结算
     */
    private Integer settlementStatus;

    /**
     * 打款时间
     */
    private Date paymentTime;

    /**
     * 上次查询id
     */
    private Long lastId;

    /**
     * 商户号列表ID
     */
    private List<String> merchantNoList;

    /**
     * 结算月份:开始
     */
    private Long monthBegin;

    /**
     * 结算月份：结束
     */
    private Long monthOver;

}