package cn.com.duiba.quanyi.center.api.dto.workflow;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/10/25 16:19
 */
@Data
public class WorkflowInstanceDetailDto implements Serializable {
    
    private static final long serialVersionUID = 229125870291072525L;

    /**
     * 节点ID，暂无使用场景。
     */
    private String activityId;

    /**
     * 节点名称。
     */
    private String activityName;

    /**
     * 流程中前一个节点的 id。
     */
    private String prevActivityId;

    /**
     * 节点操作人类型，取值：
     * approver：审批人
     * notifier：抄送人
     * audit：办理人
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowActorTypeEnum
     */
    private String actorType;

    /**
     * 任务状态
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 任务处理人
     */
    private String userId;
    
    
}
