package cn.com.duiba.quanyi.center.api.enums.project;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 项目所属业务类型
 * @date 2024/10/22
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum BelongingBusinessTypeEnum {
    BANK_CHANNEL_BUSINESS(1, "银行/渠道"),
    INSURANCE_BUSINESS(2, "保险"),
    ;

    private final Integer type;
    private final String desc;

    public static BelongingBusinessTypeEnum getEnum(Integer type) {
        for (BelongingBusinessTypeEnum enumItem : BelongingBusinessTypeEnum.values()) {
            if (enumItem.getType().equals(type)) {
                return enumItem;
            }
        }
        return null;
    }
}
