/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.log.operate.log;

import cn.com.duiba.quanyi.center.api.log.operate.log.OperateLoggerContext;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class OperateLogger {
    private static final ThreadLocal<OperateLoggerContext> THREAD_CONTEXT = new ThreadLocal();

    private OperateLogger() {
    }

    public static void appendJson(String operatorId, String operatorName, Long bizId, JSONObject extInfo) {
        OperateLoggerContext context = OperateLogger.getOperateLoggerStackContext();
        if (context == null) {
            return;
        }
        if (StringUtils.isBlank((String)operatorId)) {
            operatorId = "";
        }
        if (StringUtils.isBlank((String)operatorName)) {
            operatorName = "";
        }
        if (Objects.isNull(extInfo)) {
            extInfo = new JSONObject();
        }
        context.setOperatorId(operatorId);
        context.setOperatorName(operatorName);
        context.setBizId(bizId);
        context.setExtInfo(extInfo.toJSONString());
    }

    public static OperateLoggerContext setBizId(Long bizId) {
        OperateLoggerContext context = OperateLogger.getOperateLoggerStackContext();
        context.setBizId(bizId);
        return context;
    }

    protected static void init() {
        OperateLoggerContext context = THREAD_CONTEXT.get();
        if (Objects.isNull(context)) {
            context = new OperateLoggerContext();
            THREAD_CONTEXT.set(context);
        }
    }

    protected static OperateLoggerContext getOperateLoggerStackContext() {
        OperateLoggerContext context = THREAD_CONTEXT.get();
        if (Objects.isNull(context)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u4f4d\u4e8eSso\u64cd\u4f5c\u65e5\u5fd7\u5207\u9762\u4e2d");
        }
        return context;
    }

    protected static void clearThreadLocal() {
        THREAD_CONTEXT.remove();
    }
}

