package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceTitleDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceTitleSearchParam;
import java.util.List;

/**
 * 开票抬头管理
 * @author kjj mybatis generator 
 * @date 2024-12-02
 */
@AdvancedFeignClient
public interface RemoteInvoiceTitleService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 开票抬头管理集合
     */
    List<InvoiceTitleDto> selectList(InvoiceTitleSearchParam param);

    /**
     * 根据主键id集合查询
     * @param ids 主键集合
     * @return 开票抬头管理
     */
    List<InvoiceTitleDto> selectByIds(List<Long> ids);

    /**
     * 根据客户id查询主体
     *
     * @param partnerId 客户id
     * @return 卡票主体
     */
    List<InvoiceTitleDto> selectByPartnerId(Long partnerId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 开票抬头管理
     */
    InvoiceTitleDto selectById(Long id);

    /**
     * 新增
     * @param dto 开票抬头管理
     * @return 执行结果
     */
    int insert(InvoiceTitleDto dto);

    /**
     * 更新
     * @param dto 开票抬头管理
     * @return 影响行数
     */
    int update(InvoiceTitleDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}