package cn.com.duiba.quanyi.center.api.remoteservice.contract;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.contract.ContractSummaryDto;
import cn.com.duiba.quanyi.center.api.param.qy.contract.ContractSummarySearchParam;
import java.util.List;

/**
 * 聚宝盆合同数据统计
 * @author kjj mybatis generator 
 * @date 2024-05-17
 */
@AdvancedFeignClient
public interface RemoteContractSummaryService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 聚宝盆合同数据统计集合
     */
    List<ContractSummaryDto> selectPage(ContractSummarySearchParam param);

    /**
     * 根据合同id集合查询
     * @param contractIds 合同id集合
     * @return 合同数据统计集合
     */
    List<ContractSummaryDto> selectListByContractIds(List<Long> contractIds);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ContractSummarySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 聚宝盆合同数据统计
     */
    ContractSummaryDto selectById(Long id);

    /**
     * 新增
     * @param dto 聚宝盆合同数据统计
     * @return 执行结果
     */
    int insert(ContractSummaryDto dto);

    /**
     * 更新
     * @param dto 聚宝盆合同数据统计
     * @return 影响行数
     */
    int update(ContractSummaryDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}