package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 核销通知与批次关联表
 * @author mybatis generator 
 * @date 2024-02-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class VerifyNotifyBatchRelationSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17070322814127427L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝立减金主键, tb_alipay_activity.id
     */
    private Long verifyNotifyId;

    /**
     * 批次ID
     */
    private String stockId;

    /**
     * 批次名称
     */
    private String stockName;

    /**
     * 1:微信立减金 2:支付宝立减金
     */
    private Integer stockType;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}