package cn.com.duiba.quanyi.center.api.dto.coupon;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝立减金活动关联表
 *
 * @author kjj mybatis generator
 * @date 2023-09-22
 */
@Data
public class AlipayActivityRelationDto implements Serializable {

    private static final long serialVersionUID = 16953837461341320L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝立减金主键, tb_alipay_activity.id
     */
    private Long alipayActivityId;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 活动类型
     *
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 发放开始时间
     */
    private Date grantStartTime;

    /**
     * 发放结束时间
     */
    private Date grantEndTime;
}