package cn.com.duiba.quanyi.center.api.param.settlement;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/12/2 18:10
 */
@Builder
@Data
public class SettlementUpdateStatusParam implements Serializable {
    
    private static final long serialVersionUID = 9051573072342182909L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 原状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatusEnum
     */
    private Integer fromStatus;

    /**
     * 改后状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatusEnum
     */
    private Integer toStatus;

    /**
     * 错误信息
     */
    private String errMsg;

    /**
     * 明细文件地址
     */
    private String orderDetailUrl;

    /**
     * 已开票金额
     */
    private Long fromInvoicedAmount;

    /**
     * 已开票金额
     */
    private Long toInvoicedAmount;

    /**
     * 已回款金额
     */
    private Long fromReceivedAmount;

    /**
     * 已回款金额
     */
    private Long toReceivedAmount;
}
