package cn.com.duiba.quanyi.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 虚拟商品发放方式
 *
 * @author lizhi
 * @date 2023/9/26 14:39
 */
@Getter
@AllArgsConstructor
public enum GoodsOrderGrantTypeEnum {
    ZC(1, "直充"),
    SHORT_URL(2, "短链"),
    INPUT_ACCOUNT(3, "输入账号"),
    SHORT_URL_AUTO(4, "短链-自动领取"),
    SHORT_URL_INPUT_ACCOUNT(5, "短链-输入账号"),
    EQUITY_COUPON(6, "权益券"),
    ;

    private final Integer type;

    private final String desc;
    
    public static boolean isShortUrl(Integer type) {
        return SHORT_URL.getType().equals(type) 
                || SHORT_URL_AUTO.getType().equals(type) 
                || SHORT_URL_INPUT_ACCOUNT.getType().equals(type);
    }

}
