package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.WxBillResetDownloadStatisticDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.WxBillResetDownloadStatisticSearchParam;
import java.util.List;

/**
 * 微信账单重新下载统计表
 * @author kjj mybatis generator 
 * @date 2025-01-17
 */
@AdvancedFeignClient
public interface RemoteWxBillResetDownloadStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 微信账单重新下载统计集合
     */
    List<WxBillResetDownloadStatisticDto> selectPage(WxBillResetDownloadStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxBillResetDownloadStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信账单重新下载统计
     */
    WxBillResetDownloadStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信账单重新下载统计
     * @return 执行结果
     */
    int insert(WxBillResetDownloadStatisticDto dto);

    /**
     * 更新
     * @param dto 微信账单重新下载统计
     * @return 影响行数
     */
    int update(WxBillResetDownloadStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}