package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.Getter;

/**
 * @Description 白名单客户号类型枚举
 * @Author cuizhoujian
 * @Date 2025-01-17 15:01:26
 */
@Getter
public enum ClientNumberEnum {
    ABC_CLIENT_NUMBER(1, 1, "ABC客户号"),
    BOC_BANK_CLIENT_NUMBER(3, 3, "中行网银客户号"),
    BOC_CORE_CLIENT_NUMBER(2, 4, "中行核心客户号");

    /**
     * 客户号类型
     */
    private Integer type;
    /**
     * 白名单中奖类型
     * {@link TemplateWhiteStandEnum#getType()}
     */
    private Integer limitType;

    private String desc;

    ClientNumberEnum(Integer clientNumberType, Integer type, String desc) {
        this.type = type;
        this.limitType = limitType;
        this.desc = desc;
    }

    public static ClientNumberEnum getByLimitType (Integer limitType) {
        for (ClientNumberEnum clientNumberEnum : ClientNumberEnum.values()) {
            if (clientNumberEnum.getLimitType().equals(limitType)) {
                return clientNumberEnum;
            }
        }
        return null;
    }
}
