package cn.com.duiba.quanyi.center.api.remoteservice.mall.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.goods.MallSkuDto;

import java.util.List;
import java.util.Set;

/**
 * 商城商品sku
 * @author kjj mybatis generator 
 * @date 2024-05-25
 */
@AdvancedFeignClient
public interface RemoteMallSkuService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城商品sku
     */
    MallSkuDto selectById(Long id);

    /**
     * 根据spuId查询
     * @param mallSpuId mallSpuId
     * @return 商城商品sku集合
     */
    List<MallSkuDto> selectByMallSpuId(Long mallSpuId);

    /**
     * 根据spuId查询
     * @param mallSpuIds mallSpuIds
     * @return 商城商品sku集合
     */
    List<MallSkuDto> selectByMallSpuIds(List<Long> mallSpuIds);

    /**
     * 根据主键批量查询
     * @param ids 主键
     * @return 商城商品sku
     */
    List<MallSkuDto> selectByIds(Set<Long> ids);
}