package cn.com.duiba.quanyi.center.api.remoteservice.qy.activitystockwarn;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.activitystockwarn.ActivityStockWarnConfigDto;

/**
 * 活动告警配置表
 *
 * @author kjj mybatis generator
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteActivityStockWarnConfigService {

    /**
     * 根据活动ID查询
     *
     * @param activityId   活动ID
     * @param activityType 活动类型 1-白名单活动 2 - 兑吧卡密包 7 - API供货
     * @return ActivityStockWarnConfigDto
     */
    ActivityStockWarnConfigDto selectByActivityIdAndActivityType(Long activityId, Integer activityType);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return ActivityStockWarnConfigDto
     */
    ActivityStockWarnConfigDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 活动告警配置
     * @return 执行结果
     */
    int insert(ActivityStockWarnConfigDto dto);

    /**
     * 更新
     *
     * @param dto 活动告警配置
     * @return 影响行数
     */
    int update(ActivityStockWarnConfigDto dto);

    /**
     * 测试告警
     *
     * @param dto dto
     * @return 结果
     */
    boolean test(ActivityStockWarnConfigDto dto);

}