package cn.com.duiba.quanyi.center.api.remoteservice.bill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bill.BillTaskDetailDto;
import cn.com.duiba.quanyi.center.api.param.bill.BillTaskDetailSearchParam;
import java.util.List;

/**
 * 账单任务明细
 * @author kjj mybatis generator 
 * @date 2024-02-29
 */
@AdvancedFeignClient
public interface RemoteBillTaskDetailService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 账单任务明细集合
     */
    List<BillTaskDetailDto> selectPage(BillTaskDetailSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BillTaskDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 账单任务明细
     */
    BillTaskDetailDto selectById(Long id);

    /**
     * 新增
     * @param dto 账单任务明细
     * @return 执行结果
     */
    int insert(BillTaskDetailDto dto);

    /**
     * 更新
     * @param dto 账单任务明细
     * @return 影响行数
     */
    int update(BillTaskDetailDto dto);
}