package cn.com.duiba.quanyi.center.api.dto.insurance.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 保司资金账户变更记录表
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
public class InsuranceFundAccountChangeRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17095322687122493L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 变更类型，1-支出, 2-收入
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceFundChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 业务类型，1-权益发放，2-权益金额增加，3-权益金额追加，4-权益金额减少，5-变更发放账号，6-兑换
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceFundBizTypeEnum
     */
    private Integer bizType;

    /**
     * 关联业务唯一标识
     */
    private String bizNo;

    /**
     * 变更金额，单位分
     */
    private Long changeAmount;

    /**
     * 变更后总金额
     */
    private Long afterTotalAmount;

    /**
     * 变更后已领取金额
     */
    private Long afterTakeAmount;

    /**
     * 变更备注
     */
    private String changeRemark;
}