package cn.com.duiba.quanyi.center.api.dto.settlement.stat;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 订单统计表
 * @author mybatis generator 
 * @date 2024-11-26
 */
@Data
public class OrderStatDto implements Serializable {
     
    private static final long serialVersionUID = 17325899993339199L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 统计纬度ID，类型=1-项目ID字符串，类型=2-对接人ID字符串，以此类推
     */
    private String statId;

    /**
     * 统计纬度类型：1-项目，2-项目商品，3-对接人，4-需求，5-需求商品，6-结算单，7-微信批次号，8-支付宝批次号，9-卡密批次号，10-支付宝数币批次号，11-美团批次号，12-抖音批次号
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.stat.SettlementOrderStatTypeEnum
     */
    private Integer statType;

    /**
     * 卡单订单数量
     */
    private Long processingOrderNum;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 消耗数
     */
    private Long consumedNum;

    /**
     * 优惠金额
     */
    private Long discountAmount;

    /**
     * 应收金额
     */
    private Long receivableAmount;

    /**
     * 容差金额
     */
    private Long toleranceAmount;

    /**
     * 结算金额
     */
    private Long settlementAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 订单开始日期
     */
    private Date startTime;

    /**
     * 订单结束日期
     */
    private Date endTime;

    /**
     * 发放期垫资成本
     */
    private Long distributeAdvanceFundCost;

    /**
     * 回款期垫资成本
     */
    private Long refundAdvanceFundCost;

    /**
     * 总计垫资成本
     */
    private Long totalAdvanceFundCost;
}