package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityFundFlowDto;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayActivityFundFlowSearchParam;
import java.util.List;

/**
 * 支付宝活动资金流水
 * @author kjj mybatis generator 
 * @date 2025-01-16
 */
@AdvancedFeignClient
public interface RemoteAlipayActivityFundFlowService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝活动资金流水集合
     */
    List<AlipayActivityFundFlowDto> selectPage(AlipayActivityFundFlowSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayActivityFundFlowSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝活动资金流水
     */
    AlipayActivityFundFlowDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝活动资金流水
     * @return 执行结果
     */
    int insert(AlipayActivityFundFlowDto dto);

    /**
     * 更新
     * @param dto 支付宝活动资金流水
     * @return 影响行数
     */
    int update(AlipayActivityFundFlowDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}