package cn.com.duiba.quanyi.center.api.dto.api.doc.result;

import cn.com.duiba.quanyi.center.api.dto.api.doc.result.sync.ApiDocPkgSubSyncOrderResultDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * API文档-订单结果-券包
 * @author lizhi
 * @date 2024/7/17 10:33
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiDocPkgOrderResultDto<T extends ApiDocPkgSubSyncOrderResultDto> extends ApiDocOrderResultDto {
    
    private static final long serialVersionUID = -7690265335597876894L;

    /**
     * 固定返回 true
     * 开发者可以通过这个字段来判断是否为券包商品
     */
    private boolean goodsPkgFlag = true;

    /**
     * 券包主订单状态
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiMainOrderStatusEnum
     */
    private Integer mainOrderStatus;

    /**
     * 券包主订单号
     */
    private String mainOrderNum;

    /**
     * 券包子订单数据，json数组格式
     */
    private List<T> subOrderDataList;
    
}
