package cn.com.duiba.quanyi.center.api.param.settlement.holo;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/11/26 16:07
 */
@ToString(callSuper = true)

@EqualsAndHashCode(callSuper = true)
@Data
public class SettlementHoloGoodsParam extends PageQuery {
    
    private static final long serialVersionUID = 1775805080500643335L;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 对接人ID
     */
    private List<Long> contactsIdList;

    /**
     * 需求ID
     */
    private List<Long> demandIdList;

    /**
     * 结算周期-开始时间
     */
    private Date startDate;

    /**
     * 结算周期-结束时间
     */
    private Date endDate;

    /**
     * lockStatus
     */
    private Integer lockStatus = 0;

    /**
     * 需求商品ID
     */
    private List<Long> demandGoodsIdList;

    /**
     * 采购商品类型
     */
    private List<Integer> purchaseSpuTypeList;
}
