package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandPaymentRecordDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPaymentRecordSearchParam;
import java.util.List;
import java.util.Set;

/**
 * 付款记录
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteDemandPaymentRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 付款记录集合
     */
    List<DemandPaymentRecordDto> selectPage(DemandPaymentRecordSearchParam param);

    /**
     * 不分页查询
     * @param param
     * @return
     */
    List<DemandPaymentRecordDto> selectNotPage(DemandPaymentRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DemandPaymentRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 付款记录
     */
    DemandPaymentRecordDto selectById(Long id);

    /**
     * 根据付款申请ID集合查询
     * @param paymentInfoIds 付款申请ID集合
     * @return 付款记录
     */
    List<DemandPaymentRecordDto> selectByPaymentInfoIds(Set<Long> paymentInfoIds);

    /**
     * 新增
     * @param dto 付款记录
     * @return 执行结果
     */
    int insert(DemandPaymentRecordDto dto);

    /**
     * 更新
     * @param dto 付款记录
     * @return 影响行数
     */
    int update(DemandPaymentRecordDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}