package cn.com.duiba.quanyi.center.api.remoteservice.qy.abc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.abc.AbcBillPushRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.abc.AbcBillPushRecordSearchParam;
import java.util.List;

/**
 * 农总任务推送记录表
 * @author kjj mybatis generator 
 * @date 2024-12-13
 */
@AdvancedFeignClient
public interface RemoteAbcBillPushRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 农总任务推送记录集合
     */
    List<AbcBillPushRecordDto> selectPage(AbcBillPushRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AbcBillPushRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 农总任务推送记录
     */
    AbcBillPushRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 农总任务推送记录
     * @return 执行结果
     */
    Long insert(AbcBillPushRecordDto dto);

    /**
     * 更新
     * @param dto 农总任务推送记录
     * @return 影响行数
     */
    int update(AbcBillPushRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}