package cn.com.duiba.quanyi.center.api.utils.sm;

import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;

/**
 * @author xuzhigang
 * @date 2024/11/21 17:41
 **/
public class CcbSm4Util {
    public static String sm4Enc(String reqData, String appSec) {
        String sm4Key = appSec.substring(0, 16);
        SymmetricCrypto sm4 = SmUtil.sm4(sm4Key.getBytes());
        return sm4.encryptBase64(reqData);
    }

    public static String sm4Dec(String reqData, String appSec) {
        String sm4Key = appSec.substring(0, 16);
        SymmetricCrypto sm4 = SmUtil.sm4(sm4Key.getBytes());
        return sm4.decryptStr(reqData);
    }
}
