package cn.com.duiba.quanyi.center.api.enums.goods;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 内部订单批量关单类型枚举
 * @author yinjiaqi
 * @date 2025-02-21 11:01:34
 */
@Getter
@AllArgsConstructor
public enum GoodsOrderBatchCloseTypeEnum {
    BATCH_CLOSE_ORDER_API(1, "批量关单-api 供货订单", Lists.newArrayList(7,21)),
    BATCH_CLOSE_ORDER_KAMI(2, "批量关单-兑吧卡密订单", Lists.newArrayList(2,6)),
    BATCH_CLOSE_ORDER_ACTIVITY(3, "批量关单-活动类订单",Lists.newArrayList(1,3,4,5,8,9,10,12,13,14,15,16,17,19,25,20,23,24,26)),
    BATCH_CLOSE_ORDER_CAR(4, "批量关单-车主商城订单",Lists.newArrayList(11, 18)),
    ;
    private static final Map<Integer, GoodsOrderBatchCloseTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values())
                    .collect(Collectors.toMap(GoodsOrderBatchCloseTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;


    /**
     * 活动类型
     * 对应页面tab
     *  api供货 [7,21]
     *  兑吧卡密 [2,6]
     *  活动类 [1,3,4,5,8,9,10,12,13,14,15,16,17,19,25,20,23,24,26]
     *  车主商城 [11, 18]
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private List<Integer> activityTypeList;

    public static GoodsOrderBatchCloseTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
