package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2024/3/4 14:36
 */
@Getter
@AllArgsConstructor
public enum InsuranceEquityCommentTypeEnum {
    NORMAL_COMMENT(1, "普通评论"),
    CERTIFICATE_URL(2, "凭证链接");

    public static InsuranceEquityCommentTypeEnum getByStatus(Integer status) {
        for (InsuranceEquityCommentTypeEnum take : InsuranceEquityCommentTypeEnum.values()) {
            if (Objects.equals(take.getStatus(), status)) {
                return take;
            }
        }
        return null;
    }

    private final Integer status;

    private final String desc;
}
