package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author lizhi
 * @date 2024/11/25 16:28
 */
@AllArgsConstructor
@Getter
public enum InvoiceStatusEnum {
    PENDING_INVOICING(1, "待开票"),
    INVOICED(2, "已开票"),
    INVOICE_RED_OFFSET_APPROVAL(3, "红冲审批中"),
    INVOICE_RED_OFFSET(4, "已红冲"),


    ;
    
    private final Integer status;
    
    private final String desc;

    public static String getDescByType(int status) {
        return Stream.of(values()).filter(item -> item.getStatus() == status).
                findFirst().map(InvoiceStatusEnum::getDesc).orElse(null);
    }
}
