package cn.com.duiba.quanyi.center.api.utils;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author xuzhigang
 * @date 2024/4/18 14:32
 **/
public class StringUtil {
    private StringUtil() {
    }

    private static final String COMMA = ",";
    //中文逗号
    private static final String CH_COMMA = "，";


    public static List<String> splitStringWithComma(String str) {
        if (StringUtils.isBlank(str)) {
            return Collections.emptyList();
        }
        return Arrays.stream(str.split(COMMA)).collect(Collectors.toList());
    }

    public static List<String> splitStringWithSeparator(@NotBlank String originStr, @NotBlank String separator) {
        if (StringUtils.isAnyBlank(originStr, separator)) {
            return Collections.emptyList();
        }
        return Arrays.stream(originStr.split(separator)).collect(Collectors.toList());
    }

    public static List<Integer> splitIntegerWithSeparator(@NotBlank String originStr, @NotBlank String separator) {
        if (StringUtils.isAnyBlank(originStr, separator)) {
            return Collections.emptyList();
        }
        return Arrays.stream(originStr.split(separator)).map(Integer::valueOf).collect(Collectors.toList());
    }


    public static List<Integer> splitIntegerWithComma(String str) {
        if (StringUtils.isBlank(str)) {
            return Collections.emptyList();
        }
        return Arrays.stream(str.split(COMMA)).map(Integer::valueOf).collect(Collectors.toList());
    }

    /**
     * 中文逗号转英文逗号
     * @param str 待转换的字符串
     * @return 转换后的字符串
     */
    public static String replaceChComma(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        return str.replaceAll(CH_COMMA, COMMA);
    }

}
