package cn.com.duiba.quanyi.center.api.dto.insurance.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 保司兑换退回记录表
 * @author mybatis generator 
 * @date 2024-06-17
 */
@Data
public class InsuranceTakeRefundDto implements Serializable {
     
    private static final long serialVersionUID = 17186086424323714L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 兑换唯一流水号
     */
    private String takeOrderNo;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 业务类型：1-积分转让，2-积分兑换（支付渠道）
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceTakeBizTypeEnum
     */
    private Integer takeBizType;

    /**
     * 业务单号
     */
    private String takeBizNo;

    /**
     * 退款单号
     */
    private String refundOrderNo;

    /**
     * 退回金额，单位分
     */
    private Long refundAmount;
}