package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponFundFlowDto;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponFundFlowSearchParam;
import java.util.List;

/**
 * 微信立减金资金流水
 * @author kjj mybatis generator 
 * @date 2025-01-16
 */
@AdvancedFeignClient
public interface RemoteWxCouponFundFlowService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 微信立减金资金流水集合
     */
    List<WxCouponFundFlowDto> selectPage(WxCouponFundFlowSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxCouponFundFlowSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信立减金资金流水
     */
    WxCouponFundFlowDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信立减金资金流水
     * @return 执行结果
     */
    int insert(WxCouponFundFlowDto dto);

    /**
     * 更新
     * @param dto 微信立减金资金流水
     * @return 影响行数
     */
    int update(WxCouponFundFlowDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}