package cn.com.duiba.quanyi.center.api.dto.insurance.institution;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceInstitutionFundBizTypeEnum;
import lombok.Data;

/**
 * 保司机构资金变更记录表
 * @author mybatis generator 
 * @date 2024-03-06
 */
@Data
public class InsuranceInstitutionFundChangeRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17097071183228007L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 变更类型，1-支出, 2-收入
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceFundChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 业务类型，1-资金调整，2-新增权益，3-编辑权益，4-删除权益
     * @see InsuranceInstitutionFundBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务关联ID
     */
    private Long bizId;

    /**
     * 变更金额，单位分
     */
    private Long changeAmount;

    /**
     * 操作人手机号
     */
    private String operatorPhone;

    /**
     * 变更参数json
     */
    private String changeParam;
}