package cn.com.duiba.quanyi.center.api.dto.settlement;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算单
 * @author mybatis generator 
 * @date 2024-11-30
 */
@Data
public class SettlementDto implements Serializable {
     
    private static final long serialVersionUID = 1732951219864355L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 商品类型：1-非垫资，2-垫资
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementGoodsTypeEnum
     */
    private Integer goodsType;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 对接人ID，多个以英文逗号分隔
     */
    private String contactsIds;

    /**
     * 实际结算对接人
     */
    private Long settlementContactsId;

    /**
     * 结算需求ID，多个以英文逗号分隔
     */
    private String demandIds;

    /**
     * 结算方式
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementTypeEnum
     */
    private Integer settlementType;

    /**
     * 结算周期-开始时间
     */
    private Date startDate;

    /**
     * 结算周期-结束时间
     */
    private Date endDate;

    /**
     * 结算单名称
     */
    private String settlementName;

    /**
     * 方案key
     */
    private String programmeKey;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 应收金额，单位分
     */
    private Long receivableAmount;

    /**
     * 结算金额，单位分
     */
    private Long settlementAmount;

    /**
     * 明细文件地址
     */
    private String orderDetailUrl;

    /**
     * 容差金额
     */
    private Long toleranceAmount;

    /**
     * 容差备注
     */
    private String toleranceRemark;

    /**
     * 结算单状态：1-创建中，2-创建失败，3-待开票，4-部分开票，5-已开票待回款，6-已回款
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatusEnum
     */
    private Integer settlementStatus;

    /**
     * 商品数量
     */
    private Long goodsNum;

    /**
     * 商品唯一标记数量
     */
    private Long uniqueMarkNum;

    /**
     * 锁定状态: 1-未锁定，2-锁定中，3-锁定成功，4-锁定失败，5-解锁中，6-解锁成功，7-解锁失败
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementLockStatusEnum
     */
    private Integer lockStatus;

    /**
     * 已申请金额
     */
    private Long applyAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 错误描述
     */
    private String errMsg;

    /**
     * 最近一个发票申请ID
     */
    private Long lastInvoiceApplyId;
}