package cn.com.duiba.quanyi.center.api.dto.settlement.holo;

import cn.com.duiba.quanyi.center.api.enums.contract.SettlementMethodEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/11/30 16:43
 */
@Data
public class SettlementHoloGoodsStockAmountDto implements Serializable {
    
    private static final long serialVersionUID = 1186274173021934237L;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 消耗数-按签收结算
     */
    private Long consumedNumSign;

    /**
     * 优惠金额-按签收结算
     */
    private Long discountAmountSign;

    /**
     * 应收金额-按签收结算
     */
    private Long receivableAmountSign;

    /**
     * 消耗数-按领取结算
     */
    private Long consumedNumSuccess;

    /**
     * 优惠金额-按领取结算
     */
    private Long discountAmountSuccess;

    /**
     * 应收金额-按领取结算
     */
    private Long receivableAmountSuccess;

    /**
     * 消耗数-按核销结算
     */
    private Long consumedNumVerification;

    /**
     * 优惠金额-按核销结算
     */
    private Long discountAmountVerification;

    /**
     * 应收金额-按核销结算
     */
    private Long receivableAmountVerification;

    /**
     * 消耗数-按打款结算
     */
    private Long consumedNumPayment;

    /**
     * 优惠金额-按打款结算
     */
    private Long discountAmountPayment;

    /**
     * 应收金额-按打款结算
     */
    private Long receivableAmountPayment;

    /**
     * 消耗数-按发放结算
     */
    private Long consumedNumGrant;

    /**
     * 优惠金额-按发放结算
     */
    private Long discountAmountGrant;

    /**
     * 应收金额-按发放结算
     */
    private Long receivableAmountGrant;
    
    public Long getConsumedNum(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case VERIFICATION:
                return consumedNumVerification;
            case ORDER_SUCCESS:
                return consumedNumSuccess;
            case SIGN:
                return consumedNumSign;
            case PAYMENT:
                return consumedNumPayment;
            case GRANT:
                return consumedNumGrant;
            default:
                return null;
        }
    }
    
    public Long getDiscountAmount(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case VERIFICATION:
                return discountAmountVerification;
            case ORDER_SUCCESS:
                return discountAmountSuccess;
            case SIGN:
                return discountAmountSign;
            case PAYMENT:
                return discountAmountPayment;
            case GRANT:
                return discountAmountGrant;
            default:
                return null;
        }
    }
    
    public Long getReceivableAmount(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case VERIFICATION:
                return receivableAmountVerification;
            case ORDER_SUCCESS:
                return receivableAmountSuccess;
            case SIGN:
                return receivableAmountSign;
            case PAYMENT:
                return receivableAmountPayment;
            case GRANT:
                return receivableAmountGrant;
            default:
                return null;
        }
    }
}
