package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 结算方式
 */
@Getter
@AllArgsConstructor
public enum SettlementMethodEnum {
    /**
     * 1-按核销结算
     */
    VERIFICATION(1, "按核销结算"),

    /**
     * 2-按订单交易成功
     */
    ORDER_SUCCESS(2, "按领取结算"),
    
    SIGN(3, "按签收结算"),

    PAYMENT(4, "按打款结算"),

    GRANT(5, "按发放结算"),
    ;

    private final Integer type;

    private final String desc;

    /**
     * 通过type获取枚举
     */
    public static SettlementMethodEnum getByType(Integer type) {
        for (SettlementMethodEnum settlementMethodEnum : SettlementMethodEnum.values()) {
            if (settlementMethodEnum.getType().equals(type)) {
                return settlementMethodEnum;
            }
        }
        return null;
    }
}
