package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceSettlementRefDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceSettlementRefSearchParam;
import java.util.List;

/**
 * 发票与结算单关系表
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteInvoiceSettlementRefService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 发票与结算单关系集合
     */
    List<InvoiceSettlementRefDto> selectPage(InvoiceSettlementRefSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InvoiceSettlementRefSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 发票与结算单关系
     */
    InvoiceSettlementRefDto selectById(Long id);

    /**
     * 根据发票申请单id查询
     * @param invoiceApplyId 发票申请单id
     * @return 发票与结算单关系集合
     */
    List<InvoiceSettlementRefDto> selectByInvoiceApplyId(Long invoiceApplyId);

    /**
     * 根据发票申请单ids查询
     *
     * @param invoiceApplyIds 发票申请单ids
     * @return 发票与结算单关系集合
     */
    List<InvoiceSettlementRefDto> selectByInvoiceApplyIds(List<Long> invoiceApplyIds);

    /**
     * 根据结算单id查询
     *
     * @param settlementId 结算单id
     * @return 发票与结算单关系集合
     */
    List<InvoiceSettlementRefDto> selectBySettlementId(Long settlementId);

    /**
     * 新增
     * @param dto 发票与结算单关系
     * @return 执行结果
     */
    int insert(InvoiceSettlementRefDto dto);

    /**
     * 更新
     * @param dto 发票与结算单关系
     * @return 影响行数
     */
    int update(InvoiceSettlementRefDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}