package cn.com.duiba.quanyi.center.api.remoteservice.project;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.ProjectTechnologyConfigDto;
import cn.com.duiba.quanyi.center.api.param.qy.ProjectTechnologyConfigSearchParam;
import java.util.List;

/**
 * 项目三方接口配置表
 * @author kjj mybatis generator 
 * @date 2025-02-27
 */
@AdvancedFeignClient
public interface RemoteProjectTechnologyConfigService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 项目三方接口配置集合
     */
    List<ProjectTechnologyConfigDto> selectPage(ProjectTechnologyConfigSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ProjectTechnologyConfigSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 项目三方接口配置
     */
    ProjectTechnologyConfigDto selectById(Long id);

    /**
     * 新增
     * @param dto 项目三方接口配置
     * @return 执行结果
     */
    int insert(ProjectTechnologyConfigDto dto);

    /**
     * 更新
     * @param dto 项目三方接口配置
     * @return 影响行数
     */
    int update(ProjectTechnologyConfigDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 保存更新
     * @param dto 项目三方接口配置
     * @return 影响行数
     */
    Boolean saveOrUpdate(ProjectTechnologyConfigDto dto);
}