package cn.com.duiba.quanyi.center.api.dto.goods;

import cn.com.duiba.quanyi.center.api.dto.goods.ext.GoodsOrderExtDto;
import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2025/2/13 16:45
 */
@Data
public class GoodsOrderReissueParamDto implements Serializable {
    
    private static final long serialVersionUID = -5360307840469876260L;

    /**
     * 原订单号
     */
    private String goodsOrderNo;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 活动类型
     *
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 账户/金额等相关信息
     */
    private GoodsOrderExtDto extDto;

    /**
     * 补发原因
     */
    private String reissueReason;
}
