package cn.com.duiba.quanyi.center.api.dto.settlement.holo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author lizhi
 * @date 2024/11/26 11:15
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SettlementHoloGoodsDto extends SettlementHoloGoodsStockAmountDto {
    
    private static final long serialVersionUID = -5429237103982142525L;

    /**
     * 所属项目ID
     */
    private Long projectId;

    /**
     * 所属项目商品ID
     */
    private Long projectGoodsId;

    /**
     * 所属对接人ID
     */
    private Long contactsId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 采购商品类型
     */
    private Integer purchaseSpuType;

    /**
     * 技术商品类型
     */
    private Integer spuType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 唯一标记
     */
    private String uniqueMark;

    /**
     * 批次号，默认-
     */
    private String stockId;

    /**
     * 活动ID，默认-
     */
    private String thirdActivityId;

    /**
     * 活动名称，默认-
     */
    private String activityName;

    /**
     * 钱包号，默认-
     */
    private String walletNum;

    /**
     * 面额
     */
    private Long couponAmount;

    /**
     * 最小结算费率
     */
    private String minSettlementRate;

    /**
     * 最大结算费率
     */
    private String maxSettlementRate;

    /**
     * 最小结算价
     */
    private Long minSettlementPrice;

    /**
     * 最大结算价
     */
    private Long maxSettlementPrice;

    /**
     * 卡单订单数量
     */
    private Long processingOrderNum;
}
