package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2024/9/6 15:22
 **/
@Getter
@AllArgsConstructor
public enum SendLimitTypeEnum {
    API(1, "仅API发放"),
    ALIPAY_QRCODE(2, "支付宝二维码及链接发放"),
    API_AND_ALIPAY_QRCODE(3, "支付宝二维码及链接发放及API发放"),;

    private Integer type;
    private String desc;

    public static SendLimitTypeEnum getByType(Integer type) {
        for (SendLimitTypeEnum item : SendLimitTypeEnum.values()) {
            if (item.getType().equals(type)) {
                return item;
            }
        }
        return null;
    }
}
