package cn.com.duiba.quanyi.center.api.enums.pkg;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 券码券链接维度
 * <p>
 * 活动维度:一个活动下所有渠道的券码券链接都一样
 * </p>
 * <p>
 * 渠道维度:一个活动下所有渠道的券码券链接都不一样，每个渠道的券码券链接唯一
 * </p>
 */
@Getter
@AllArgsConstructor
public enum CodeCouponLinkDimensionEnum {

    ACTIVITY_DIMENSION(1, "活动维度"),
    CHANNEL_DIMENSION(2, "渠道维度"),
    ;

    private final Integer type;

    private final String desc;
}
