package cn.com.duiba.quanyi.center.api.enums.settlement.receive;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/12/11 14:26
 */
@AllArgsConstructor
@Getter
public enum SettlementReceivedStatusEnum {
    // 状态：
    //待关联-自动关联-取消关联中-待关联（同意）/自动关联（拒绝）
    //待关联-关联中-已关联（同意）-取消关联中-待关联（同意）/已关联（同意）
    //待关联-关联中-待关联（拒绝）
    // 全部/待关联/关联中/撤销中/已关联/自动关联
    TO_BE_ASSOCIATED(1, "待关联"),
    ASSOCIATING(2, "关联中"),
    ASSOCIATED(3, "已关联"),
    AUTO_ASSOCIATION(4, "自动关联"),
    CANCELLING(5, "撤销中"),
    ;
    
    private final Integer status;
    
    private final String desc;
}
