package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementDto;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementEditParam;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementSaveParam;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementSearchParam;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementUpdateStatusParam;

import java.util.List;

/**
 * 结算单
 * @author kjj mybatis generator 
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算单集合
     */
    List<SettlementDto> selectPage(SettlementSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SettlementSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算单
     */
    SettlementDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键id集合
     * @return 结算单
     */
    List<SettlementDto> selectByIds(List<Long> ids);

    /**
     * 保存结算单
     * @param param 请求参数
     * @return 主键
     */
    Long save(SettlementSaveParam param);

    /**
     * 更改状态
     * @param param 参数
     * @return 执行结果
     */
    int updateStatus(SettlementUpdateStatusParam param);

    /**
     * 更改锁定状态
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 更改为的状态
     * @param errMsg 错误原因
     * @return 执行结果
     */
    int updateLockStatus(Long id, Integer fromStatus, Integer toStatus, String errMsg);

    /**
     * 编辑基础信息
     * @param param 编辑参数
     * @return 执行结果
     */
    int edit(SettlementEditParam param);

    /**
     * 逻辑删除删除
     * @param id 主键
     * @return 执行结果
     */
    int deleteNotLock(Long id);
}