package cn.com.duiba.quanyi.center.api.dto.api;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * API供货用户与openId等绑定
 * @author mybatis generator 
 * @date 2024-09-03
 */
@Data
public class ApiUidBindDto implements Serializable {
     
    private static final long serialVersionUID = 17253341204003552L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 三方用户唯一标记
     */
    private String uid;

    /**
     * 对接配置Id
     */
    private Long apiJointId;

    /**
     * 绑定类型
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiUidBindTypeEnum
     */
    private Integer bindType;

    /**
     * 绑定ID（微信openId/支付宝openId等，根据绑定类型确定）
     */
    private String bindId;
}