package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceApplyTaskDto;

/**
 * 结算单锁定或解锁任务表
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteInvoiceApplyTaskService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算单锁定或解锁任务
     */
    InvoiceApplyTaskDto selectById(Long id);

    /**
     * 更改任务状态
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 更改后状态
     * @param errMsg 错误原因
     * @return 影响行数
     */
    int updateStatus(Long id, Integer fromStatus, Integer toStatus, String errMsg);
}