package cn.com.duiba.quanyi.center.api.dto.invoice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 发票与结算单关系表
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
public class InvoiceSettlementRefDto implements Serializable {
     
    private static final long serialVersionUID = 173320673356366L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 发票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 发票ID
     */
    private Long invoiceId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 结算单占用金额
     */
    private Long occupyAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 回款ID，格式：回款ID_金额，回款ID_金额
     */
    private String receivedIds;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 关联类型：1-结算单开票，2-预付款开票，3-预付款抵扣
     * @see cn.com.duiba.quanyi.center.api.enums.invoice.InvoiceSettlementRefTypeenum
     */
    private Integer refType;

    /**
     * 预付款ID
     */
    private Long prepaymentId;
}