package cn.com.duiba.quanyi.center.api.dto.settlement.prepayment;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 预付款
 * @author mybatis generator 
 * @date 2025-03-05
 */
@Data
public class PrepaymentDto implements Serializable {
     
    private static final long serialVersionUID = 17411533395288786L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 创建时的发票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 规则：1-项目下全部对接人可用，2-指定对接人可用
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.prepayment.PrepaymentUsageRulesEnum
     */
    private Integer usageRules;

    /**
     * 对接人ID，多个以英文逗号分隔
     */
    private String contactsIds;

    /**
     * 预付款名称
     */
    private String prepaymentName;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.prepayment.PrepaymentStatusEnum
     */
    private Integer prepaymentStatus;

    /**
     * 预付金额，单位分
     */
    private Long prepaidAmount;

    /**
     * 已开票金额，单位分
     */
    private Long invoicedAmount;

    /**
     * 已回款金额，单位分
     */
    private Long receivedAmount;

    /**
     * 已抵扣金额，单位分
     */
    private Long deductionAmount;
}