package cn.com.duiba.quanyi.center.api.param.invoice;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author lizhi
 * @date 2024/12/25 11:07
 */
@Data
public class InvoiceFillReceivedAmountMqParam implements Serializable {
    
    private static final long serialVersionUID = 1452255199009427712L;

    /**
     * 回款ID
     */
    private Long receiveId;

    /**
     * 结算统计任务类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 发票关联的金额
     */
    private Map<Long, Long> invoiceAmountMap;

    /**
     * 开票申请关联的金额
     */
    private Map<Long, Long> invoiceApplyAmountMap;

    /**
     * 总金额，用于校验
     */
    private Long totalAmount;

    /**
     * 重试次数
     */
    private int retryCount;
}
