package cn.com.duiba.quanyi.center.api.remoteservice.settlement.prepayment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.prepayment.PrepaymentDto;
import cn.com.duiba.quanyi.center.api.param.settlement.prepayment.PrepaymentSearchParam;
import java.util.List;

/**
 * 预付款
 * @author kjj mybatis generator 
 * @date 2025-03-05
 */
@AdvancedFeignClient
public interface RemotePrepaymentService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 预付款集合
     */
    List<PrepaymentDto> selectPage(PrepaymentSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(PrepaymentSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 预付款
     */
    PrepaymentDto selectById(Long id);

    /**
     * 新增
     * @param dto 预付款
     * @return 执行结果
     */
    int insert(PrepaymentDto dto);

    /**
     * 更新
     * @param dto 预付款
     * @return 影响行数
     */
    int update(PrepaymentDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}