package cn.com.duiba.quanyi.center.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 建行钉钉联合营销钉钉个人小程序用户信息表
 *
 * @author mybatis generator
 * @date 2023-11-21
 */
@Data
public class CcbDingtalkUserExtDto implements Serializable {

    private static final long serialVersionUID = 17005708172585308L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户的手机号
     */
    private String mobile;

    /**
     * 用户的钉钉昵称
     */
    private String nick;

    /**
     * 用户的unionId
     */
    private String unionId;

    /**
     * 用户的openId
     */
    private String openId;

    /**
     * 头像URL
     */
    private String avatarUrl;

    /**
     * 手机号对应的国家号
     */
    private String stateCode;

    /**
     * 用户的个人邮箱
     */
    private String email;

    /**
     * 建行返回的报名接口返回的报名记录编号
     */
    private String regRecordId;

    /**
     * S20-新客已达标达标；S30-存量老客户
     *
     * @see cn.com.duiba.quanyi.center.api.enums.user.CcbDingtalkCstStatusEnum
     */
    private String cstStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}