package cn.com.duiba.quanyi.center.api.enums.settlement;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/11/25 16:27
 */
@AllArgsConstructor
@Getter
public enum InvoiceApplyStatusEnum {
    
    // 1.保存申请记录（原子保存锁定任务） - 申请中
    // 2.尝试触发任务（定时任务与该处同一把锁，锁ID-项目ID）-申请中
    // 3.若有锁定任务失败，将申请记录改为锁定失败，写入解锁任务，并异步触发，同时记录失败原因-申请失败
    // 4.锁定任务成功后，触发判断申请记录下结算单是否全部成功，若成功，同步更改申请记录为锁定成功-申请中
    // 5.发起钉钉审批，成功-待开票
    // 6.发起钉钉审批，失败-申请失败
    // 7.钉钉审批拒绝-已开票金额0时，写释放锁定任务，异步触发-审批拒绝 //有开票金额时，仅更改审批状态，不更改主状态
    // 8.回填/回退开票金额时，
    
    // 上传/红冲/删除发票
    // 1.改开票状态
    // 2.回填/回退开票申请 已开票金额，改状态为待开票/部分开票/待回款（原状态也必须是这些状态内的）
    // 3.回填/回退结算单 已开票金额
    // 4.写开票红冲/删除任务
    APPLICATION_IN_PROGRESS(1, "申请中"),
    APPLICATION_FAILED(2, "申请失败"),
    APPROVAL_REJECTED(3, "审批拒绝"),
    PENDING_INVOICING(4, "待开票"),
    PARTIAL_INVOICING(5, "部分开票"),
    PENDING_COMPLETE(6, "待完成"),
    PENDING_PAYMENT(7, "待回款"),
    RECEIVED_PAYMENT(8, "已回款"),
    CLOSE(9, "已关闭"),
    ;

    private final Integer status;

    private final String desc;

    public static boolean canRetry(Integer status) {
        return APPLICATION_FAILED.getStatus().equals(status);
    }
}
